/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.MCFFileParser;
import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.updates.McfKeyword;
import com.ibm.hwmca.base.updates.MclKeywordListenerManager;
import com.ibm.hwmca.base.updates.NewMCLDataFileFilter;
import com.ibm.hwmca.base.util.IssueCmd;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MCL
extends UpdateCollection
implements MCLErrorIds {
    private static final String TRACE_MASKT = "XMCLMCLT";
    private static final String TRACE_MASKF = "XMCLMCLF";
    private static final String TRACE_MASKD = "XMCLMCLD";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    private Date lastStatusChangeDate;
    private boolean error;
    private boolean disruptive;
    private boolean inTransition;
    private int state;
    private int id;
    private String stringId;
    private List updates;
    private String stagingAreaPath;
    private Set corequisites;
    private Set prerequisites;
    private Set hardPrerequisites;
    private boolean ignoreHardPrerequisites;
    private LocalizableText displayableError;
    private ECStream ecData;
    private String ecStream;

    public MCL(ECStream ecData, int id) throws HException {
        this(ecData, id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MCL(ECStream ecData, int id, boolean skipFileParsing) throws HException {
        super(ecData);
        Trace.trace(TRACE_MASKT, "-> MCL()");
        this.id = id;
        this.ecStream = ecData.getECNumber();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        this.stringId = nf.format(this.id);
        if (!skipFileParsing) {
            block11: {
                this.stagingAreaPath = ecData.getStagingAreaPath();
                File stagingArea = new File(this.stagingAreaPath);
                NewMCLDataFileFilter filter = new NewMCLDataFileFilter(this.ecStream, id, id);
                String[] newFiles = stagingArea.list(filter);
                if (newFiles.length > 0) {
                    String mclFileName = this.stagingAreaPath + newFiles[0];
                    Trace.trace(TRACE_MASKF, "   MCL()MCF file [" + mclFileName + "] exists. Unpack it.");
                    String patchCmd = "unzip -o " + mclFileName + " -d " + this.stagingAreaPath;
                    Trace.trace(TRACE_MASKD, "UNZIP command is [" + patchCmd + "]");
                    try {
                        IssueCmd cmd = new IssueCmd();
                        int rc = cmd.execute(patchCmd);
                        if (1 == rc) {
                            Trace.trace(TRACE_MASKF, "UNZIP [" + patchCmd + "] failed " + "with a return code of " + rc + "\n" + "Command output was:\n" + cmd.getErrorOutput());
                        }
                        if (rc > 1) {
                            this.logError("UNZIP [" + patchCmd + "] failed " + "with a return code of " + rc + "\n" + "Command output was:\n" + cmd.getErrorOutput(), (short)-3960);
                        }
                        Object var13_14 = null;
                        File mclFile = new File(mclFileName);
                        if (mclFile.delete()) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        File mclFile = new File(mclFileName);
                        if (!mclFile.delete()) {
                            this.logError("Error deleting " + mclFileName, (short)-3961);
                        }
                        throw throwable;
                    }
                    this.logError("Error deleting " + mclFileName, (short)-3961);
                }
            }
            String testString = this.ecStream + "." + this.stringId + ".xml";
            Trace.trace(TRACE_MASKD, "XML test file=[" + this.stagingAreaPath + testString + "]");
            File testFile = new File(this.stagingAreaPath + testString);
            if (testFile.exists()) {
                Trace.trace(TRACE_MASKF, "XML file exists. Parse it.");
                try {
                    this.ecData = ecData;
                    this.parseNewMCL(testString);
                }
                catch (HException e) {
                    this.error = true;
                    this.logError("Error parsing MCL file " + testString, (short)-3885, e);
                    throw e;
                }
            }
        }
        this.state = ecData.getAppliedLevel() < id ? 1 : 5;
        int stagedLevel = ecData.getStagedLevel();
        if (stagedLevel == id - 1 || -1 == stagedLevel) {
            this.lastStatusChangeDate = new Date();
            ecData.addMCL(this);
        }
        Trace.trace(TRACE_MASKT, "<- MCL()");
    }

    private void parseNewMCL(String filename) throws HException {
        Trace.trace(TRACE_MASKT, "-> parseNewMCL(" + filename + ")");
        try {
            MCFFileParser parser = new MCFFileParser(this.stagingAreaPath + filename);
            Document document = parser.getDocument();
            this.corequisites = new TreeSet();
            this.prerequisites = new TreeSet();
            this.hardPrerequisites = new TreeSet();
            this.updates = new ArrayList();
            this.traverse(document);
        }
        catch (HException e) {
            this.error = true;
            this.logAndRethrowError("Error parsing MCL file " + filename, (short)-3885, e);
        }
        Trace.trace(TRACE_MASKT, "<- parseNewMCL()");
    }

    private void traverse(Node node) throws HException {
        Trace.trace(TRACE_MASKT, "-> traverse()");
        try {
            short nodeType = node.getNodeType();
            if (nodeType == 9) {
                Trace.trace(TRACE_MASKD, "Traversing Document node.");
                Document doc = (Document)node;
                this.traverse(doc.getDocumentElement());
            } else if (nodeType == 1) {
                String text = "";
                String nodeName = node.getNodeName();
                Trace.trace(TRACE_MASKD, "name of node=[" + nodeName + "].");
                if (nodeName.equals("mclfile") || nodeName.equals("dependencies") || nodeName.equals("keywords") || nodeName.equals("mcfs")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.traverse(children.item(i));
                    }
                } else if (nodeName.equals("disruptive-info")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    if ((text = text.toLowerCase()).equals("nondisruptive")) {
                        this.disruptive = false;
                    } else if (text.equals("disruptive")) {
                        this.disruptive = true;
                    }
                    Trace.trace(TRACE_MASKD, "disruptive= " + (this.disruptive ? "true" : "false"));
                } else if (nodeName.equals("dependency")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    StringTokenizer tokens = new StringTokenizer(text, " =;");
                    if (tokens.hasMoreTokens()) {
                        String type = tokens.nextToken();
                        if (tokens.hasMoreTokens()) {
                            String dependency = tokens.nextToken();
                            int dotPosition = dependency.indexOf(".");
                            int equalPosition = dependency.indexOf("=");
                            String ecNumber = dependency.substring(equalPosition + 1, dotPosition);
                            int level = Integer.parseInt(dependency.substring(dotPosition + 1), 10);
                            UpdateLevel dependencyLevel = new UpdateLevel(ecNumber, level);
                            if (type.equals("PREREQ")) {
                                this.prerequisites.add(dependencyLevel);
                            } else if (type.equals("COREQ")) {
                                this.corequisites.add(dependencyLevel);
                            } else if (type.equals("ACTREQ")) {
                                this.hardPrerequisites.add(dependencyLevel);
                            }
                            Trace.trace(TRACE_MASKD, "dependency type=[" + type + "]");
                            Trace.trace(TRACE_MASKD, "dependency=[" + dependency + "]");
                        }
                    }
                } else if (nodeName.equals("keyword")) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 3) continue;
                        text = text + current.getNodeValue();
                    }
                    McfKeyword keyword = new McfKeyword(text);
                    MclKeywordListenerManager mklm = MclKeywordListenerManager.getMclKeywordListenerManager();
                    mklm.keywordDiscovered(keyword, this);
                } else if (nodeName.equals("mcf")) {
                    String name = "";
                    String mcfName = "";
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node current = attributes.item(i);
                        name = current.getNodeName();
                        if (!name.equals("id")) continue;
                        mcfName = current.getNodeValue() + ".xml";
                        Trace.trace(TRACE_MASKD, "MCF=[" + mcfName + "].");
                        this.updates.add(new MCF(this.ecData, this, mcfName));
                    }
                }
            }
        }
        catch (HException exc) {
            this.error = true;
            this.logError("Error traversing DOM node ", (short)-3884, exc);
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- traverse()");
    }

    public boolean equals(Object obj) {
        boolean same = false;
        if (this == obj) {
            same = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            same = false;
        } else {
            MCL otherMCL = (MCL)obj;
            if (this.id == otherMCL.getId() && this.ecStream.equals(otherMCL.getUpdateableComponent().getECNumber())) {
                same = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<> MCL.equals() returns " + same);
        return same;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.id;
        String data = "Exception";
        try {
            data = this.ecStream;
        }
        catch (Exception exception) {
            // empty catch block
        }
        hash = 31 * hash + (null == data ? 0 : data.hashCode());
        return hash;
    }

    public Date getLastStatusChangeDate() {
        Date out = this.lastStatusChangeDate;
        if (out != null) {
            out = (Date)this.lastStatusChangeDate.clone();
        }
        return out;
    }

    public Set getCorequisites() {
        return this.corequisites;
    }

    public Set getHardPrerequisites() {
        Set hp = new TreeSet();
        if (!this.ignoreHardPrerequisites) {
            hp = this.hardPrerequisites;
        }
        return hp;
    }

    public Set getPrerequisites() {
        return this.prerequisites;
    }

    public List getUpdates() {
        return this.updates;
    }

    public int getState() {
        return this.state;
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayableName() {
        return this.ecStream + "." + this.stringId;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isDisruptive() {
        return this.disruptive;
    }

    public boolean isInTransition() {
        return this.inTransition;
    }

    public void setIgnoreHardPrerequisites(boolean ignore) {
        this.ignoreHardPrerequisites = ignore;
    }

    public void delete() throws HException {
        Trace.trace(TRACE_MASKT, "-> delete(" + this.id + ")");
        this.inTransition = true;
        ECStream ec = (ECStream)super.getUpdateableComponent();
        try {
            String xmlFile = this.stagingAreaPath + this.ecStream + "." + this.stringId + ".xml";
            File xmlFileToDelete = new File(xmlFile);
            List allMCFs = this.getUpdates();
            Iterator counterOfMCFs = allMCFs.iterator();
            while (counterOfMCFs.hasNext()) {
                MCF nextMCF = (MCF)counterOfMCFs.next();
                try {
                    nextMCF.delete(true);
                }
                catch (Exception e) {
                    this.logError("Unable to delete an MCF within this MCL", (short)-3892, e);
                }
            }
            this.state = 0;
            this.inTransition = false;
            ec.removeMCL(this);
            Trace.trace(TRACE_MASKF, "The MCL file" + xmlFile + " is being deleted.");
            xmlFileToDelete.delete();
        }
        catch (Exception e) {
            HException hexc = new HException(e);
            this.inTransition = false;
            this.logAndRethrowError("Unable to delete MCL " + this.id + " " + e, (short)-3968, hexc);
        }
        Trace.trace(TRACE_MASKT, "<- delete()");
    }

    public void commit() throws HException {
        Trace.trace(TRACE_MASKT, "-> commit(" + this.id + ")");
        this.inTransition = true;
        ECStream ec = (ECStream)super.getUpdateableComponent();
        try {
            String xmlFile = this.stagingAreaPath + this.ecStream + "." + this.stringId + ".xml";
            File xmlFileToDelete = new File(xmlFile);
            List allMCFs = this.getUpdates();
            Iterator counterOfMCFs = allMCFs.iterator();
            while (counterOfMCFs.hasNext()) {
                MCF nextMCF = (MCF)counterOfMCFs.next();
                if (nextMCF.isConfigurationSpecific()) continue;
                try {
                    nextMCF.commit();
                }
                catch (Exception e) {
                    this.logError("Unable to commit an MCF within this MCL", (short)-3891, e);
                }
            }
            this.state = 6;
            this.inTransition = false;
            ec.removeMCL(this);
            Trace.trace(TRACE_MASKF, "The MCL file" + xmlFile + " is being deleted.");
            xmlFileToDelete.delete();
        }
        catch (Exception e) {
            HException hexc = new HException(e);
            this.inTransition = false;
            this.logAndRethrowError("Unable to accept MCL " + this.id + " " + e, (short)-3967, hexc);
        }
        Trace.trace(TRACE_MASKT, "<- commit()");
    }

    public void apply() throws HException {
        Trace.trace(TRACE_MASKT, "-> apply(" + this.id + ")");
        this.inTransition = true;
        ECStream ec = (ECStream)super.getUpdateableComponent();
        try {
            List allMCFs = this.getUpdates();
            Iterator counterOfMCFs = allMCFs.iterator();
            while (counterOfMCFs.hasNext()) {
                MCF nextMCF = (MCF)counterOfMCFs.next();
                if (nextMCF.isConfigurationSpecific()) continue;
                nextMCF.apply(true);
            }
            this.state = 5;
            this.lastStatusChangeDate = new Date();
            ec.setAppliedLevel(this.id, this.lastStatusChangeDate);
        }
        catch (HException e) {
            this.inTransition = false;
            this.logError("Unable to install and activate MCL " + this.id + " " + e, (short)-3966);
        }
        this.inTransition = false;
        Trace.trace(TRACE_MASKT, "<- apply()");
    }

    public void reject() throws HException {
        Trace.trace(TRACE_MASKT, "-> reject(" + this.id + ")");
        this.inTransition = true;
        ECStream ec = (ECStream)super.getUpdateableComponent();
        try {
            List allMCFs = this.getUpdates();
            Iterator counterOfMCFs = allMCFs.iterator();
            while (counterOfMCFs.hasNext()) {
                MCF nextMCF = (MCF)counterOfMCFs.next();
                if (nextMCF.isConfigurationSpecific()) continue;
                nextMCF.reject(true);
            }
            this.state = 1;
            this.lastStatusChangeDate = new Date();
            ec.setAppliedLevel(this.id - 1, this.lastStatusChangeDate);
        }
        catch (HException e) {
            this.inTransition = false;
            this.logError("Unable to remove and activate MCL " + this.id + " " + e, (short)-3965);
        }
        this.inTransition = false;
        Trace.trace(TRACE_MASKT, "<- reject()");
    }

    protected void readFully(BufferedReader instream, char[] buffer) throws IOException {
        int allBytesRead;
        int bytesRead;
        Trace.trace(TRACE_MASKF, "-> readFully()");
        for (allBytesRead = 0; allBytesRead < buffer.length; allBytesRead += bytesRead) {
            bytesRead = instream.read(buffer, allBytesRead, buffer.length - allBytesRead);
            Trace.trace(TRACE_MASKD, "<- read() read " + bytesRead + " bytes.");
        }
        Trace.trace(TRACE_MASKF, "<- readFully() read " + allBytesRead + " bytes.");
    }

    protected void logError(String errorString, short errorId) throws HException {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        HException hexc = new HException(errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.displayableError = new LocalizableText(errorString);
        throw hexc;
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.displayableError = new LocalizableText(errorString);
    }

    protected void logAndRethrowError(String errorString, short errorId, Exception e) throws HException {
        Trace.trace(TRACE_MASKD, "-> logAndRethrowError()");
        Trace.trace(TRACE_MASKF, errorString);
        this.displayableError = new LocalizableText(errorString);
        HException hexc = new HException(e);
        new FrameworkLog(logInfo, errorId, hexc).log();
        throw hexc;
    }
}

